/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer;

import filenet.sim.animationdp.IVWSIMAnimationDP;
import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorQueue;
import filenet.sim.toolkit.viewer.VWSIMAnimatorRoute;
import filenet.sim.toolkit.viewer.VWSIMAnimatorScenario;
import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.resources.VWSIMResource;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Container;
import java.util.Vector;

public class VWSIMAnimatorDataModel
implements Runnable {
    public static final int INIT_NONE = 0;
    public static final int INIT_RETRIEVING_SIMULATION_DOC = 1;
    public static final int INIT_RETRIEVING_SCENARIO_DEFINITION = 2;
    public static final int INIT_STEP_DEFINITION = 3;
    public static final int INIT_HISTORY = 4;
    public static final int INIT_RUNTIME_DATA = 5;
    public static final int INIT_SUCCESS = 6;
    public static final int INIT_FAILED = 7;
    private IVWSIMSimulation m_simulation = null;
    private IVWSIMAnimationDP m_animationDP = null;
    private Container m_mainContainer = null;
    private volatile int m_initState = 0;
    private boolean m_bInitializing = false;
    private volatile String m_initMsgString = "";
    private volatile String m_initSubMsgString = "";
    private volatile boolean m_initThreadWaiting = false;
    private volatile boolean m_getMsgThreadWating = false;
    private Object m_updatingInitMsg = new Object();
    private Object m_semaphore = new Object();
    private Object m_trackerMode = new Object();
    private boolean m_bSync = false;
    private Thread m_thread = null;
    VWSIMAnimatorScenario m_scenario = null;
    String m_currentUser = null;

    public VWSIMAnimatorDataModel(Container container, IVWSIMSimulation simulation) throws Exception {
        this.m_mainContainer = container;
        this.m_simulation = simulation;
        this.m_animationDP = this.m_simulation.getAnimationDataProvider();
        this.m_thread = new Thread((Runnable)this, "VWSIMAnimatorDataModelThread");
        this.m_thread.start();
    }

    public VWSIMAnimatorDataModel(Container container, IVWSIMAnimationDP animationDP) throws Exception {
        this.m_mainContainer = container;
        this.m_simulation = null;
        this.m_animationDP = animationDP;
        this.m_thread = new Thread((Runnable)this, "VWSIMAnimatorDataModelThread");
        this.m_thread.start();
    }

    public void run() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            VWDebug.logException(e);
            this.m_initState = 7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() throws Exception {
        if (this.m_initState == 7 || this.m_initState == 6 || this.m_bInitializing) {
            return;
        }
        this.m_bInitializing = true;
        try {
            Object object = this.m_semaphore;
            synchronized (object) {
                Object object2 = this.m_trackerMode;
                synchronized (object2) {
                    Object object3 = this.m_updatingInitMsg;
                    synchronized (object3) {
                        this.m_initMsgString = VWSIMResource.s_retrievingSimulationDoc;
                        this.m_initSubMsgString = null;
                        this.m_initState = 1;
                    }
                }
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initMsgString = VWSIMResource.s_retrievingScenarioDefinition;
                    this.m_initSubMsgString = null;
                    this.m_initState = 2;
                }
                if (this.m_simulation != null) {
                    this.m_scenario = new VWSIMAnimatorScenario(this, this.m_simulation.getScenariodefinition());
                } else if (this.m_animationDP != null) {
                    this.m_scenario = new VWSIMAnimatorScenario(this, this.m_animationDP.getScenarioDefinition());
                } else {
                    throw new Exception(VWSIMResource.s_failedToRetrieveScenarioDefinition);
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initSubMsgString = null;
                    this.m_initState = 4;
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initSubMsgString = null;
                    this.m_initState = 4;
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initSubMsgString = null;
                    this.m_initState = 5;
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initState = 6;
                    this.m_initSubMsgString = null;
                }
            }
        }
        catch (Exception ex) {
            Object object = this.m_updatingInitMsg;
            synchronized (object) {
                this.m_initState = 7;
                this.m_initSubMsgString = ex.getLocalizedMessage();
            }
            VWDebug.logException(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInitMsgStrings() {
        while (true) {
            Object object = this.m_updatingInitMsg;
            synchronized (object) {
                String[] msgs = new String[2];
                String msg = this.m_initMsgString;
                if (msg != null) {
                    if (this.isInitializing()) {
                        this.m_initMsgString = null;
                    }
                    msgs[0] = msg;
                    msgs[1] = this.m_initSubMsgString;
                    return msgs;
                }
                if (!this.isInitializing()) {
                    return null;
                }
            }
            this.m_bSync = true;
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            object = this.m_semaphore;
            synchronized (object) {
                this.m_bSync = false;
                this.m_semaphore.notifyAll();
            }
        }
    }

    public int getInitState() {
        return this.m_initState;
    }

    public boolean isInitializing() {
        return this.m_initState != 6 && this.m_initState != 7;
    }

    static Vector sortSteps(Vector list) {
        if (list != null && list.size() > 1) {
            Vector<VWSIMAnimatorStep> v = new Vector<VWSIMAnimatorStep>();
            int index = 0;
            for (int i = 0; i < list.size(); ++i) {
                String name1;
                VWSIMAnimatorStep step = (VWSIMAnimatorStep)list.elementAt(i);
                String name = step.getStepName();
                for (index = 0; index < v.size() && VWStringUtils.compareIgnoreCase(name, name1 = ((VWSIMAnimatorStep)v.elementAt(index)).getStepName()) >= 0; ++index) {
                }
                v.insertElementAt(step, index);
            }
            list = v;
        }
        return list;
    }

    static Vector sortRoutes(Vector list) {
        if (list != null && list.size() > 1) {
            Vector<VWSIMAnimatorRoute> v = new Vector<VWSIMAnimatorRoute>();
            int index = 0;
            for (int i = 0; i < list.size(); ++i) {
                VWSIMAnimatorRoute route = (VWSIMAnimatorRoute)list.elementAt(i);
                String name = route.getRouteName();
                if (name != null) {
                    String name1;
                    for (index = 0; index < v.size() && ((name1 = ((VWSIMAnimatorRoute)v.elementAt(index)).getRouteName()) == null || VWStringUtils.compareIgnoreCase(name, name1) >= 0); ++index) {
                    }
                }
                v.insertElementAt(route, index);
            }
            list = v;
        }
        return list;
    }

    public VWSIMAnimatorScenario getScenario() {
        return this.m_scenario;
    }

    public Vector getQueues() {
        if (this.m_scenario != null) {
            return this.m_scenario.getQueues();
        }
        return null;
    }

    public VWSIMAnimatorQueue findQueue(String name) {
        if (this.m_scenario != null) {
            return this.m_scenario.findQueue(name);
        }
        return null;
    }

    protected VWSIMAnimatorQueue newQueue(VWQueueDefinition queueDef) {
        if (this.m_scenario != null) {
            return this.m_scenario.newQueue(queueDef.getName());
        }
        return null;
    }

    protected VWSIMAnimatorQueue newQueue(String name) {
        if (this.m_scenario != null) {
            return this.m_scenario.newQueue(name);
        }
        return null;
    }

    public Vector getWorkflows() {
        if (this.m_scenario != null) {
            return this.m_scenario.getWorkflows();
        }
        return null;
    }

    public Vector getAllMaps() {
        if (this.m_scenario != null) {
            return this.m_scenario.getAllMaps();
        }
        return null;
    }

    public VWSIMAnimatorMap getSelectedMap() {
        Vector maps = this.getAllMaps();
        if (maps != null) {
            Object obj = null;
            for (int i = 0; i < maps.size(); ++i) {
                obj = maps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap) || !((VWSIMAnimatorMap)obj).isSelected()) continue;
                return obj;
            }
        }
        return null;
    }

    public IVWSIMSimulation getSimulation() {
        return this.m_simulation;
    }

    public String getSimulationName() {
        try {
            if (this.m_simulation != null) {
                return this.m_simulation.getName();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex, ex.getLocalizedMessage());
        }
        return null;
    }

    public synchronized void clearStatistics() {
        if (this.m_scenario != null) {
            this.m_scenario.clearStatistics();
        }
    }

    public boolean canStopSimulation() {
        if (this.m_simulation != null) {
            try {
                return this.m_simulation.canStop();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                return false;
            }
        }
        return false;
    }

    public boolean stopSimulation() {
        if (this.canStopSimulation()) {
            try {
                this.m_simulation.stop();
                if (this.m_animationDP != null) {
                    this.m_animationDP.stopRetrieval();
                }
                return true;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                return false;
            }
        }
        return false;
    }

    public void releaseResources() {
        this.m_simulation = null;
        this.m_animationDP = null;
        this.m_mainContainer = null;
        this.m_initMsgString = null;
        this.m_initSubMsgString = null;
        this.m_updatingInitMsg = null;
        this.m_semaphore = null;
        this.m_trackerMode = null;
        this.m_currentUser = null;
        if (this.m_scenario != null) {
            this.m_scenario.releaseResources();
            this.m_scenario = null;
        }
        if (this.m_thread != null) {
            try {
                this.m_thread.join();
                this.m_thread = null;
            }
            catch (InterruptedException ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void writeScenarioDefinitionToFile(String filename) throws VWException {
        if (filename != null && this.m_scenario != null) {
            this.m_scenario.writeScenarioDefinitionToFile(filename);
        }
    }
}

